﻿using System;
using System.Net;

using System.Collections.ObjectModel;
using System.Collections.Generic;

namespace iXTankenAndroid
{
    public class MainViewModel:ViewModelBase
    {
        private List<TankVorgang> _DataSource = null;

        public List<TankVorgang> DataSource 
        { 
            get 
            { 
                if (_DataSource == null) 
                { 
                    _DataSource = new List<TankVorgang>();
                } 
                return _DataSource; 
            } 
            private set 
            { 
                if (_DataSource != value) 
                { 
                    _DataSource = value; 
                } 
            } 
        }

        public void Initialize()
        {
            LoadDataAction(null);
        }

        public void LoadDataAction(object p) 
        { 
            IEnumerable<TankVorgang> tankVorgangList = this.GetService<ITankvorgangModelService>().GetTankVorgangList(); 
            this.DataSource = new List<TankVorgang>(tankVorgangList); 
        }

        public void AddNewTankVorgang(object p)
        { 
            this.GetService<INavigationService>().NavigateToAddNewTankVorgang(); 
        }

        public MainViewModel()
        {        
            LoadDataAction(null);
        }
    }
}
